#include <windows.h>

LRESULT CALLBACK WndProc( HWND, UINT, WPARAM, LPARAM);

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
	PSTR lpszCmdParam, int nCmdShow)
{
	static char szAppName[] = "HellowWin";
	HWND masterhwnd; //A handle (int) correpsonding to your window.
	MSG msg; //A Windows message data structure
	WNDCLASSEX wndclass; //Use this to register the WndProc window procedure.

	if (!hPrevInstance) //If this is the first instance being run,
	{ //then define and register a window class for this program.
		wndclass.cbSize = sizeof(wndclass);
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc; //The window procedure defined below
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
		wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
		wndclass.hbrBackground = (HBRUSH)GetStockObject( BLACK_BRUSH );
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = szAppName;
		wndclass.hIconSm = LoadIcon( NULL, IDI_APPLICATION ); //The small icon in caption bar
		RegisterClassEx (&wndclass);
	}
	//Now create an instance of your new window class.
	masterhwnd = CreateWindowEx(
			WS_EX_OVERLAPPEDWINDOW, //fancy window style
			szAppName,		// window class name
		"Hello3. Move mouse, click left and right,press M,G,B,R,X,M. 8/14/97 Rudy Rucker",	// window caption
			WS_OVERLAPPEDWINDOW,		// window style
			CW_USEDEFAULT,			// initial x position
			CW_USEDEFAULT,			// initial y position
			CW_USEDEFAULT,			// initial x size
			CW_USEDEFAULT,			// initial y size
			NULL,					// parent window handle
			NULL,					// window menu handle
			hInstance,				// program instance handle
			NULL);				// creation parameters
		//This sends WM_CREATE to WndProc, where initialization happens.

	ShowWindow(masterhwnd, nCmdShow); //This draws the window with a
		//blank background and sends WM_SIZE and WM_SHOW to WndProc.
	UpdateWindow(masterhwnd); //Sends WM_PAINT to WndProc to put
		//your info in the window.

	while ( GetMessage( &msg, NULL, 0, 0 ) ) //While msg.message is not WM_QUIT
	{
		TranslateMessage(&msg);
			//Convert keystroke messages into character messages.
		DispatchMessage(&msg);  //Send the msg to WndProc.
	}

	return msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	HDC hdc; //Handle to a device context, this knows a window's size.
	PAINTSTRUCT ps;
	RECT rect; //Structure with four int fields: left, top, right, bottom
	static BOOL movedrawflag = FALSE;
	static COLORREF textcolor = RGB(255, 0, 0);

		switch (message)
	{
		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			GetClientRect(hwnd, &rect);
			SetBkMode(hdc, TRANSPARENT);
			SetTextColor(hdc, RGB(255, 0, 0));
			DrawText(hdc, "Hello, Windows!", -1, &rect,
				DT_SINGLELINE | DT_CENTER | DT_VCENTER); //Formatting flags.
			SetTextColor(hdc, RGB(255, 0, 0));
			DrawText(hdc, "Goodbye, DOS!", -1, &rect,
				DT_SINGLELINE | DT_RIGHT | DT_BOTTOM);
			SetTextColor(hdc, RGB(0, 255, 0));
			TextOut(hdc, 20, 40, "(20, 40)", lstrlen("(20, 40)"));
			EndPaint(hwnd, &ps);
			return 0;

		case WM_LBUTTONDOWN:
			hdc = GetDC(hwnd);
			SetBkMode(hdc, TRANSPARENT);
			SetTextColor(hdc, RGB(0, 255, 255));
			TextOut(hdc, LOWORD (lParam), HIWORD (lParam),
				"Left!", lstrlen("Leftk!"));
			ReleaseDC(hwnd, hdc);
			return 0;

		case WM_RBUTTONDOWN:
			hdc = GetDC(hwnd);
			SetBkMode(hdc, TRANSPARENT);
			SetTextColor(hdc, RGB(255, 255, 0));
			TextOut(hdc, LOWORD (lParam), HIWORD (lParam),
				"Right!", lstrlen("Right!"));
			ReleaseDC(hwnd, hdc);
			return 0;

		case WM_MOUSEMOVE:
			if (movedrawflag)
			{
				hdc = GetDC(hwnd);
				SetBkMode(hdc, TRANSPARENT);
				SetTextColor(hdc, textcolor);
				TextOut(hdc, LOWORD (lParam), HIWORD (lParam),
					"Move!", lstrlen("Move!"));
				ReleaseDC(hwnd, hdc);
			}
			return 0;

		case WM_CHAR:
			switch (wParam)
			{
				case 'm':
					movedrawflag ^= TRUE;
					break;
				case 'q':
					SendMessage( hwnd, WM_DESTROY, 0, 0L ); //Goes to WndProc.
					break;
				case 'x':
					//Clear the screen by invalidating the
					//client area and sending a WM_PAINT.
					InvalidateRect(hwnd, NULL, TRUE);
					//The NULL means use the full client area, the TRUE
					//means erase the window before repainting.
					break;
				case 'r':
					textcolor = RGB(255,0,0);
					break;
				case 'g':
					textcolor = RGB(0,255,0);
					break;
				case 'b':
					textcolor = RGB(0,0,255);
					break;
				default:
					hdc = GetDC(hwnd);
					SetBkMode(hdc, TRANSPARENT);
					SetTextColor(hdc, RGB(255, 255, 128));
					POINT curpos;
					GetCursorPos(&curpos);
					ScreenToClient(hwnd, &curpos);
					char letter[1];
					letter[0] = wParam;
					TextOut(hdc, curpos.x, curpos.y, letter, 1);
					ReleaseDC(hwnd, hdc);
					break;
			}
			return 0;

		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
	}

	return DefWindowProc(hwnd, message, wParam, lParam);
		//DefWindowProc is the default message handler.
}
